"Tiny Gardens"

[This is by Emily Short]

Chapter 1 - Laying Out Rooms

Use full-length room descriptions.

After deciding the scope of the player:
repeat with the way running through directions
begin;
let first step be the room the way from the location;
if the first step is a room
begin;
place the first step in scope;
let second step be the room the way from the first step;
if the second step is a room, place the second step in scope;
end if;
end repeat.

Understand "look [direction]" or "look to/toward [direction]" as
facing.

Facing is an action applying to one visible thing.

Carry out facing:
let the viewed item be the room noun from the location;
if the viewed item is not a room, say "You can't see anything
promising that way." instead;
try looking toward the viewed item.

Instead of facing up:
say "Above you is bright sky."

Understand "look toward [any adjacent room]" as looking toward.

Looking toward is an action applying to one visible thing.

Carry out looking toward:
change the chosen direction to the best route from the location to the
noun;
change the second noun to the room the chosen direction from the noun;
if the noun contains something mentionable
begin;
say "Off to [the chosen direction], you can see [a list of
mentionable things in the noun].";
end if.

Chosen direction is a direction that varies.

Chapter 2 - Height

A thing can be tiny, small, large, or monumental.

Definition: a thing is mentionable if it stands tall enough to see.

To decide whether (item - a thing) stands tall enough to see:
if the item is mentioned, no;
if the item is in an adjacent room and item is not tiny, yes;
if the item is large or the item is monumental, yes;
no.

[This is so that tiny items in nearby rooms are not mentioned, and
small items in rooms 2-away are also not mentioned. If you don't want
that level of detail, you can streamline further.]

Instead of examining something which is within a room (called the
space) which is not the location:
if the location is adjacent to the space
begin;
if the noun is tiny, say "It is too far from here for you to make out
much detail about [the noun]." instead;
let way be the best route from the location to the space;
if the way is a direction, say "You gaze off [way] at [the noun]...";
continue the action;
otherwise;
if the noun is small, say "It is too far from here for you to make
out much detail about [the noun]." instead;
let way be the best route from the location to the space;
if the way is a direction, say "You gaze off [way] into the distance
at [the noun]...";
continue the action;
end if.

Before doing something other than examining to something which is not
enclosed by the location:
let the destination be the location of the noun;
let the way be the best route from the location to the destination;
if way is not a direction, say "You can't get there from here."
instead;
say "(heading [way] first)[line break]";
try going the way.

Chapter 3 - Ways and Means

The Herb Garden is a room. "Along this side of the house run your
great-aunt's herb beds." The Herb Garden contains a penny and a trash
can. The penny is tiny. The trash can is a large container.

A Grassy Room is a kind of room. The printed name of a Grassy Room is
usually "Lawn". The description of a Grassy Room is "The grass
underfoot is thick and green. The lawn extends to [grassy directions]
from here."

[Note that we are handling the similar rooms with related room
descriptions by giving them all essentially the same description and
then changing a specific portion according to a say phrase:]

To say grassy directions:
repeat with way running through directions
begin;
if the room way from the location is a grassy room, now the way is
marked for listing;
end repeat;
say "[list of directions which are marked for listing]";
now every direction is not marked for listing.

Lawn1 is west of the Herb Garden. It contains a picnic table and a
wicker basket. The picnic table is a large supporter. The basket is a
small container.

Lawn2 is south of Lawn1 and southeast of Lawn4. Lawn3 is southwest of
Lawn1, west of Lawn2, and south of Lawn4. Lawn4 is west of Lawn1. Lawn4
contains a birdbath. The birdbath is large and fixed in place.

Lawn1, Lawn2, Lawn3, and Lawn4 are Grassy Rooms.

The Driveway is north of Lawn1. The Driveway contains a basketball
hoop, a ball, and a mountain bike. The bike is large. The ball is
small. The hoop is monumental and fixed in place.

After looking (this is the distant nondescript items rule):
let total be the number of adjacent rooms which contain something
mentionable;
if total is greater than 0
begin;
now every mentionable thing is marked for listing;
say "You make out ";
let index be 0;
repeat with way running through directions
begin;
let next room be the room the way from the location;
if the next room is a room and the next room contains something
mentionable
begin;
increase index by 1;
list the contents of the next room, as a sentence, tersely, listing
marked items only;
say " to [the way]";
if total minus 1 is the index, say "[if using the serial comma
option],[end if] and ";
otherwise if index is less than total, say ", ";
end if;
end repeat;
say ".";
otherwise;
say paragraph break;
end if;
rule succeeds. 



